#include "pvmuser.h"
#include "pvm_consts.h"
#include "xab.h"

void
FUNCTION(fbarrier) ARGS(`STRING_ARG(name), n, cc')
STRING_ARG_DECL(name);
int *n;
int *cc;
{
	char tname[MAX_BARRIER_NAME + 1];

	if (STRING_LEN(name) > MAX_BARRIER_NAME) {
		*cc = pvm_uerr("fbarrier", PvmTooLong);
		return;
	}
	strncpy(tname, STRING_PTR(name), STRING_LEN(name));
	tname[STRING_LEN(name)] = '\0';
	*cc = barrier(tname, *n);
}
